## Create (Function)

Creates a function.




### Description

icCube allows for declaring a function at schema level. This function is then available as any other regular MDX function (e.g., topCount). The syntax for declaring a function is very much similar to the declaration of a calculated member.

The optional `CACHED` property allows for caching the evaluation (default is true). Applies to `STATIC` or `CONST` functions only.

The optional `CUBE` property allows for specifying the cube the function is evaluated with. There is no need to mention the cube if the function is executed within a `SELECT` statement or if there is one cube only in the schema or if the function does not require any evaluation. Applies to `STATIC` functions only.

<pre>
CREATE [ STATIC | CONST ] [NATIVE] FUNCTION name( arg, ... ) AS ... [ , CUBE = cube-name ] [, CACHED = yes|true ]
</pre>

<b>Native Functions</b>

A function can be declared as `native` using the `NATIVE` keyword. In that case, it is not defined using MDX. icCube supports both Java and R integrations. Please refer to the [integration](../mdx_integration/index.md) section for more details.

The following examples are demonstrating several features of these function declarations. See the [Declared Functions](Declared%20Functions.md) page for more details.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### factorial

</div>

<div class="ic3-mdx-example-body" style="display:none">

In this example, we are defining the factorial of a number. You may notice the usage of a recursive notation.

**Query**

```
CREATE FUNCTION _factorial(n) AS Iif( n = 0, 1, n * _factorial(n-1) )
            
             
                
WITH
    MEMBER f0 AS _factorial(0)
    MEMBER f3 AS _factorial(3)

SELECT { f0, f3 } ON 0 FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">f0</td>
  <td class="ic3-mdx-result-cell-header">f3</td>
</tr>
<tr>
 <td>1</td>
 <td>6</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER f0 AS 1
    MEMBER f3 AS 6

SELECT { f0, f3 } ON 0 FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[Declared Functions](Declared%20Functions.md)

[Drop (Function)](Drop%20(Function).md)

[Create (Member)](Create%20(Member).md)

[Create (Set)](Create%20(Set).md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
